/*
 * Decompiled with CFR 0.152.
 */
package org.fife.util;

import java.io.Serializable;
import java.util.Arrays;

public class DynamicIntArray
implements Serializable {
    private int[] data;
    private int size;

    public DynamicIntArray() {
        this(10);
    }

    public DynamicIntArray(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal initialCapacity: " + initialCapacity);
        }
        this.data = new int[initialCapacity];
        this.size = 0;
    }

    public DynamicIntArray(int[] intArray) {
        this.size = intArray.length;
        int capacity = (int)Math.min((long)this.size * 110L / 100L, Integer.MAX_VALUE);
        this.data = new int[capacity];
        System.arraycopy(intArray, 0, this.data, 0, this.size);
    }

    public void add(int value2) {
        this.ensureCapacity(this.size + 1);
        this.data[this.size++] = value2;
    }

    public void add(int index2, int[] intArray) {
        if (index2 > this.size) {
            this.throwException2(index2);
        }
        int addCount = intArray.length;
        this.ensureCapacity(this.size + addCount);
        int moveCount = this.size - index2;
        if (moveCount > 0) {
            System.arraycopy(this.data, index2, this.data, index2 + addCount, moveCount);
        }
        System.arraycopy(this.data, index2, intArray, 0, moveCount);
        this.size += addCount;
    }

    public void add(int index2, int value2) {
        if (index2 > this.size) {
            this.throwException2(index2);
        }
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.data, index2, this.data, index2 + 1, this.size - index2);
        this.data[index2] = value2;
        ++this.size;
    }

    public void clear() {
        this.size = 0;
    }

    public boolean contains(int integer) {
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != integer) continue;
            return true;
        }
        return false;
    }

    public void decrement(int from2, int to2) {
        int i = from2;
        while (i < to2) {
            int n = i++;
            this.data[n] = this.data[n] - 1;
        }
    }

    private final void ensureCapacity(int minCapacity) {
        int oldCapacity = this.data.length;
        if (minCapacity > oldCapacity) {
            int[] oldData = this.data;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.data = new int[newCapacity];
            System.arraycopy(oldData, 0, this.data, 0, this.size);
        }
    }

    public void fill(int value2) {
        Arrays.fill(this.data, value2);
    }

    public int get(int index2) {
        if (index2 >= this.size) {
            this.throwException(index2);
        }
        return this.data[index2];
    }

    public int getUnsafe(int index2) {
        return this.data[index2];
    }

    public int getSize() {
        return this.size;
    }

    public void increment(int from2, int to2) {
        int i = from2;
        while (i < to2) {
            int n = i++;
            this.data[n] = this.data[n] + 1;
        }
    }

    public void insertRange(int offs, int count2, int value2) {
        if (offs > this.size) {
            this.throwException2(offs);
        }
        this.ensureCapacity(this.size + count2);
        System.arraycopy(this.data, offs, this.data, offs + count2, this.size - offs);
        if (value2 != 0) {
            Arrays.fill(this.data, offs, offs + count2, value2);
        }
        this.size += count2;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void remove(int index2) {
        int toMove;
        if (index2 >= this.size) {
            this.throwException(index2);
        }
        if ((toMove = this.size - index2 - 1) > 0) {
            System.arraycopy(this.data, index2 + 1, this.data, index2, toMove);
        }
        --this.size;
    }

    public void removeRange(int fromIndex, int toIndex) {
        if (fromIndex >= this.size || toIndex > this.size) {
            this.throwException3(fromIndex, toIndex);
        }
        int moveCount = this.size - toIndex;
        System.arraycopy(this.data, toIndex, this.data, fromIndex, moveCount);
        this.size -= toIndex - fromIndex;
    }

    public void set(int index2, int value2) {
        if (index2 >= this.size) {
            this.throwException(index2);
        }
        this.data[index2] = value2;
    }

    public void setUnsafe(int index2, int value2) {
        this.data[index2] = value2;
    }

    private final void throwException(int index2) throws IndexOutOfBoundsException {
        throw new IndexOutOfBoundsException("Index " + index2 + " not in valid range [0-" + (this.size - 1) + "]");
    }

    private final void throwException2(int index2) throws IndexOutOfBoundsException {
        throw new IndexOutOfBoundsException("Index " + index2 + ", not in range [0-" + this.size + "]");
    }

    private final void throwException3(int fromIndex, int toIndex) throws IndexOutOfBoundsException {
        throw new IndexOutOfBoundsException("Index range [" + fromIndex + ", " + toIndex + "] not in valid range [0-" + (this.size - 1) + "]");
    }
}

